#include "central_widget.h"
#include <QApplication>  //setProperty() と sender() に必要
#include <QLabel>
#include <QMessageBox>

Central_Widget::Central_Widget(QWidget *parent)
 : QWidget(parent) {
 //グリッドレイアウト．プッシュボタンを配置して周期表とする
 grid_layout = new QGridLayout(this);
 setLayout(grid_layout);

 //各元素に対応するプッシュボタンを 119 個作成
 for(int i = 1; i < ELEMENT_CNT; ++i) {
  button_array[i] = new QPushButton(SYMBOL[i].data(), this);
  button_array[i]->setProperty("id", i);  //ボタンの ID 番号を設定
  button_array[i]->setFixedSize(50, 30);
  if(VDW_RADIUS[i] == 0.0)
   button_array[i]->setStyleSheet("color:red; background:lightyellow;");
  else
   button_array[i]->setStyleSheet("color:blue; background:lightyellow;");
  //プッシュボタンがクリックされたときに呼び出される関数
  connect(button_array[i], SIGNAL(clicked()), this, SLOT(slot_atom_button_pushed()));
 }

 //上で作成したプッシュボタンを，周期表になるようにグリッドレイアウトに配置
 grid_layout->addWidget(button_array[1], 0, 0);  //水素
 grid_layout->addWidget(button_array[2], 0, 17);  //ヘリウム
 int row = 1;
 int col = 0;
 for(int i = 3; i <= 4; ++i)  //リチウムとベリリウム
  grid_layout->addWidget(button_array[i], row, col++);
 col = 12;
 for(int i = 5; i <= 10; ++i) //ホウ素〜ネオン．以下同様
  grid_layout->addWidget(button_array[i], row, col++);
 row = 2;
 col = 0;
 for(int i = 11; i <= 12; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 col = 12;
 for(int i = 13; i <= 18; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 row = 3;
 col = 0;
 for(int i = 19; i <= 36; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 row = 4;
 col = 0;
 for(int i = 37; i <= 54; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 row = 5;
 col = 0;
 for(int i = 55; i <= 56; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 col = 3;
 for(int i = 72; i <= 86; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 row = 6;
 col = 0;
 for(int i = 87; i <= 88; ++i)
  grid_layout->addWidget(button_array[i], row, col++);
 col = 3;
 for(int i = 104; i <= 118; ++i)
  grid_layout->addWidget(button_array[i], row, col++);

 //ランタノイド
 QLabel *label_la = new QLabel("*1", this);
 label_la->setAlignment(Qt::AlignCenter);
 grid_layout->addWidget(label_la, 5, 2);

 QLabel *label_la2 = new QLabel("*1 ランタノイド", this);
 label_la2->setAlignment(Qt::AlignHCenter);
 grid_layout->addWidget(label_la2, 7, 1, 7, 2);

 int n = 57;
 for(int i = 3; i <= 17; ++i)
  grid_layout->addWidget(button_array[n++], 7, i);

 //アクチノイド
 QLabel *label_ac = new QLabel("*2", this);
 grid_layout->addWidget(label_ac, 6, 2);
 label_ac->setAlignment(Qt::AlignCenter);

 QLabel *label_ac2 = new QLabel("*2 アクチノイド", this);
 grid_layout->addWidget(label_ac2, 8, 1, 8, 2);
 label_ac2->setAlignment(Qt::AlignHCenter);

 n = 89;
 for(int i = 3; i <= 17; ++i)
  grid_layout->addWidget(button_array[n++], 8, i);
}

void Central_Widget::slot_atom_button_pushed() {
 int id = (sender()->property("id")).toInt();  //ボタン作成時に設定した ID

 //表示するデータは，global.h に配列として記している
 QString info = QString(SYMBOL[id].data()) + '\n' + "共有結合半径：" + QString::number(COVALENT_RADIUS[id]) + '\n' + "ファンデルワールス半径：" + QString::number(VDW_RADIUS[id]);
 QMessageBox::information(this, "情報", info);
}
