#ifndef ___GLOBAL_H
#define ___GLOBAL_H

#include <string>

const int ELEMENT_CNT(119);

const std::string SYMBOL[ELEMENT_CNT]  {
/*  UNKNOWN  */ "UCS",
/*   1 -  10 */   "H",  "He",  "Li",  "Be",   "B",   "C",   "N",   "O",   "F",  "Ne",
/*  11 -  20 */  "Na",  "Mg",  "Al",  "Si",   "P",   "S",  "Cl",  "Ar",   "K",  "Ca",
/*  21 -  30 */  "Sc",  "Ti",   "V",  "Cr",  "Mn",  "Fe",  "Co",  "Ni",  "Cu",  "Zn",
/*  31 -  40 */  "Ga",  "Ge",  "As",  "Se",  "Br",  "Kr",  "Rb",  "Sr",   "Y",  "Zr",
/*  41 -  50 */  "Nb",  "Mo",  "Tc",  "Ru",  "Rh",  "Pd",  "Ag",  "Cd",  "In",  "Sn",
/*  51 -  60 */  "Sb",  "Te",   "I",  "Xe",  "Cs",  "Ba",  "La",  "Ce",  "Pr",  "Nd",
/*  61 -  70 */  "Pm",  "Sm",  "Eu",  "Gd",  "Tb",  "Dy",  "Ho",  "Er",  "Tm",  "Yb",
/*  71 -  80 */  "Lu",  "Hf",  "Ta",   "V",  "Re",  "Os",  "Ir",  "Pt",  "Au",  "Hg",
/*  81 -  90 */  "Tl",  "Pb",  "Bi",  "Po",  "At",  "Rn",  "Fr",  "Ra",  "Ac",  "Th",
/*  91 - 100 */  "Pa",   "U",  "Np",  "Pu",  "Am",  "Cm",  "Bk",  "Cf",  "Es",  "Fm",
/* 101 - 110 */  "Md",  "No",  "Lr",  "Rf",  "Db",  "Sg",  "Bh",  "Hs",  "Mt",  "Ds",
/* 111 - 118 */  "Rg", "Uub", "Uut", "Uuq", "Uup", "Uuh", "Uus", "Uuo"
};

//'http://ja.wikipedia.org/wiki/共有結合半径' の単結合を Å で表記したもの
const double COVALENT_RADIUS[ELEMENT_CNT] = {
/* UCS 用  */ 0.0,
/*   1 -  10 */ 0.32, 0.46, 1.33, 1.02, 0.85, 0.75, 0.71, 0.63, 0.64, 0.67,
/*  11 -  20 */ 1.55, 1.39, 1.26, 1.16, 1.11, 1.03, 0.99, 0.96, 1.96, 1.71,
/*  21 -  30 */ 1.48, 1.36, 1.34, 1.22, 1.19, 1.16, 1.11, 1.10, 1.12, 1.18,
/*  31 -  40 */ 1.24, 1.24, 1.21, 1.16, 1.14, 1.17, 2.10, 1.85, 1.63, 1.54,
/*  41 -  50 */ 1.47, 1.38, 1.28, 1.25, 1.25, 1.20, 1.28, 1.36, 1.42, 1.40,
/*  51 -  60 */ 1.40, 1.36, 1.33, 1.31, 2.32, 1.96, 1.80, 1.63, 1.76, 1.74,
/*  61 -  70 */ 1.73, 1.72, 1.68, 1.69, 1.68, 1.67, 1.66, 1.65, 1.64, 1.70,
/*  71 -  80 */ 1.62, 1.52, 1.46, 1.37, 1.31, 1.29, 1.22, 1.23, 1.24, 1.33,
/*  81 -  90 */ 1.44, 1.44, 1.51, 1.45, 1.47, 1.42, 2.23, 2.01, 1.86, 1.75,
/*  91 - 100 */ 1.69, 1.70, 1.71, 1.72, 1.66, 1.66, 1.66, 1.68, 1.65, 1.67,
/* 101 - 110 */ 1.73, 1.76, 1.61, 1.57, 1.49, 1.43, 1.41, 1.34, 1.29, 1.28,
/* 111 - 118 */ 1.21, 1.22, 1.36, 1.43, 1.62, 1.75, 1.65, 1.57
};

//'http://www.webelements.com/periodicity/van_der_waals_radius/' を改変．値が不明な原子は 0.00 としている
const double VDW_RADIUS[ELEMENT_CNT] = {
/* UCS 用  */ 0.00,
/*   1 -  10 */ 1.20, 1.40, 1.82, 0.00, 0.00, 1.70, 1.55, 1.52, 1.47, 1.54,
/*  11 -  20 */ 2.27, 1.73, 0.00, 2.10, 1.80, 1.80, 1.75, 1.88, 2.75, 0.00,
/*  21 -  30 */ 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.63, 1.40, 1.39,
/*  31 -  40 */ 1.87, 0.00, 1.85, 1.90, 1.85, 2.02, 0.00, 0.00, 0.00, 0.00,
/*  41 -  50 */ 0.00, 0.00, 0.00, 0.00, 0.00, 1.63, 1.72, 1.58, 1.93, 2.17,
/*  51 -  60 */ 0.00, 2.06, 1.98, 2.16, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
/*  61 -  70 */ 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
/*  71 -  80 */ 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.75, 1.66, 1.55,
/*  81 -  90 */ 1.96, 2.02, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
/*  91 - 100 */ 0.00, 1.86, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
/* 101 - 110 */ 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
/* 111 - 118 */ 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00
};

#endif
